from cryptography.hazmat.primitives import hashes, serialization
from cryptography.hazmat.primitives.asymmetric import padding
from base4096 import encode

# Load private key
with open("zchg_private_key.pem", "rb") as f:
    private_key = serialization.load_pem_private_key(f.read(), password=None)

# Sign a message
message_bytes = b"Hello world, ZCHG official message"
signature_bytes = private_key.sign(
    message_bytes,
    padding.PKCS1v15(),
    hashes.SHA256()
)

# Encode signature in Base4096
signature_b4096 = encode(signature_bytes)
print("Base4096 signature:", signature_b4096)
